/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.animationdp.impl2;

import filenet.sim.animationdp.impl2.AnimationManager;
import filenet.sim.animationdp.impl2.IVWSIMEventBuffer;
import filenet.sim.animationdp.impl2.IVWSIMEventReader;
import filenet.sim.animationdp.impl2.VWSIMFileEventReader;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.RandomAccessFile;

class VWSIMFileEventBuffer
implements IVWSIMEventBuffer {
    private File m_outFile = null;
    private File m_indexFile = null;
    private File m_timeFile = null;
    protected long m_size = 0L;
    private boolean m_finished = false;
    private String m_scenarioId = null;
    protected static Logger logger = Logger.getLogger("filenet.sim.animationdp.retrieval");
    protected String m_className = "VWSIMFileEventBuffer";
    protected RandomAccessFile m_fContents = null;
    protected RandomAccessFile m_fIndex = null;
    protected RandomAccessFile m_fTime = null;
    private int m_status = 0;
    private String m_statusMessage = null;

    protected String getScenarioId() {
        return this.m_scenarioId;
    }

    protected File getFile() {
        return this.m_outFile;
    }

    protected File getIndexFile() {
        return this.m_indexFile;
    }

    protected File getTimeFile() {
        return this.m_timeFile;
    }

    public VWSIMFileEventBuffer(String scenarioId) throws VWException {
        this.m_scenarioId = scenarioId;
        try {
            this.m_outFile = File.createTempFile("simC", ".dat");
            this.m_outFile.deleteOnExit();
            this.m_indexFile = File.createTempFile("simIX", ".inx");
            this.m_indexFile.deleteOnExit();
            this.m_timeFile = File.createTempFile("simIX", ".time");
            this.m_timeFile.deleteOnExit();
            this.m_className = this.m_className + ":";
            this.m_className = this.m_className + this.m_scenarioId;
            logger.info(this.m_className, "<init>", "File=" + this.m_outFile.getCanonicalPath() + ", indexFile=" + this.m_indexFile.getCanonicalPath() + ", timeFile=" + this.m_timeFile.getCanonicalPath());
        }
        catch (Throwable e) {
            throw new VWException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int log(byte[][] b) throws VWException {
        int nItems;
        block11: {
            String m_method = "log";
            boolean hasSomething = false;
            nItems = 0;
            try {
                if (b == null) {
                    return nItems;
                }
                logger.fine(this.m_className, "log", "opening for writing " + this.m_outFile.getCanonicalPath());
                if (this.m_fContents == null) {
                    this.m_fContents = new RandomAccessFile(this.m_outFile, "rwd");
                }
                logger.fine(this.m_className, "log", "opening index for writing " + this.m_indexFile.getCanonicalPath());
                if (this.m_fIndex == null) {
                    this.m_fIndex = new RandomAccessFile(this.m_indexFile, "rwd");
                }
                logger.fine(this.m_className, "log", "opening time for writing " + this.m_timeFile.getCanonicalPath());
                if (this.m_fTime == null) {
                    this.m_fTime = new RandomAccessFile(this.m_timeFile, "rwd");
                }
                int nCount22 = b.length;
                for (int i = 0; i < nCount22; ++i) {
                    AnimationManager[] mgr;
                    if (b[i] == null || (mgr = AnimationManager.fromBytes(b[i])).length <= 0 || mgr[0] == null) continue;
                    long pos = this.m_fContents.getFilePointer();
                    this.m_fTime.writeLong(mgr[0].getTimeStamp().getTime());
                    this.m_fIndex.writeLong(pos);
                    this.m_fContents.write(b[i]);
                    this.m_finished = mgr[0].finished();
                    this.m_status = mgr[0].getStatus();
                    this.m_statusMessage = mgr[0].getStatusMessage();
                    ++this.m_size;
                    ++nItems;
                    hasSomething = true;
                    if (this.m_finished) {
                        this.m_fIndex.close();
                        this.m_fIndex = null;
                        this.m_fTime.close();
                        this.m_fTime = null;
                        this.m_fContents.close();
                        this.m_fContents = null;
                    }
                    if (!this.m_finished && this.m_size % 1000L != 0L) continue;
                    logger.info(this.m_className, "log", "[" + Long.toString(this.m_size) + "]:" + mgr[0].getTimeStamp().toString() + (this.m_finished ? " DONE." : " NOT DONE."));
                }
                if (!hasSomething) break block11;
                VWSIMFileEventBuffer nCount22 = this;
                synchronized (nCount22) {
                    this.notifyAll();
                }
            }
            catch (Throwable e) {
                this.markFinished(65535, e.getMessage());
                logger.throwing(this.m_className, "log", e);
                throw new VWException(e);
            }
        }
        return nItems;
    }

    public IVWSIMEventReader getReader() throws VWException {
        return new VWSIMFileEventReader(this);
    }

    public synchronized void markFinished(int status, String statusMessage) {
        this.m_finished = true;
        this.m_status = status;
        this.m_statusMessage = statusMessage;
        if (logger.isFinest()) {
            logger.finest(this.m_className, "markFinished", this.m_statusMessage + ":" + this.m_status);
        }
        AnimationManager finishedEvent = new AnimationManager(this.m_finished, this.m_status, this.m_statusMessage);
        try {
            if (this.m_fIndex != null && this.m_fContents != null && this.m_fTime != null) {
                this.m_fTime.writeLong(finishedEvent.getTimeStamp().getTime());
                this.m_fIndex.writeLong(this.m_fContents.getFilePointer());
                finishedEvent.writeToStream(this.m_fContents);
                this.m_fIndex.close();
                this.m_fIndex = null;
                this.m_fTime.close();
                this.m_fTime = null;
                this.m_fContents.close();
                this.m_fContents = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.notifyAll();
    }

    public synchronized void releaseResources() {
        this.m_size = 0L;
        try {
            if (this.m_outFile != null) {
                this.m_outFile.delete();
            }
            if (this.m_indexFile != null) {
                this.m_indexFile.delete();
            }
            if (this.m_timeFile != null) {
                this.m_timeFile.delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void writeToFile(String fileName) throws VWException {
        block22: {
            Exception e222;
            FilterOutputStream out;
            BufferedInputStream in;
            block20: {
                if (!this.m_finished) {
                    throw new VWException("filenet.sim.animationdp.impl.FileEventBuffer.writeToFile.notFinished", "Incomplete data transfer.");
                }
                File destFile = new File(fileName);
                if (destFile.exists()) {
                    destFile.delete();
                }
                in = null;
                out = null;
                in = new BufferedInputStream(new FileInputStream(this.m_outFile));
                out = new BufferedOutputStream(new FileOutputStream(destFile));
                int b = 0;
                while ((b = in.read()) != -1) {
                    ((BufferedOutputStream)out).write(b);
                }
                Object var7_7 = null;
                if (in == null) break block20;
                try {
                    in.close();
                }
                catch (Exception e222) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e222) {}
            }
            break block22;
            {
                catch (Exception e3) {
                    Exception e222;
                    Object var7_8 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e222) {
                            // empty catch block
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception e222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception e222;
                Object var7_9 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e222) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public int getStatus() {
        return this.m_status;
    }

    public String getStatusMessage() {
        return this.m_statusMessage;
    }

    public boolean finished() {
        return this.m_finished;
    }

    protected long getSize() {
        return this.m_size;
    }
}

